<?php

require_once __DIR__ . "/../core/AdmitadClient.php";
require_once __DIR__ . "/../core/Cache.php";

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

$cacheKey = "admitad_campaigns";

$cached = Cache::get($cacheKey, CAMPAIGN_CACHE_TTL);
if ($cached) {
    echo json_encode($cached);
    exit;
}

$client = new AdmitadClient();

$data = $client->get("/advcampaigns/", [
    "website" => 2783211,
    "status" => "active"
]);

Cache::put($cacheKey, $data);

echo json_encode($data);
