<?php

require_once __DIR__ . "/../config/constants.php";

class AdmitadAuth
{
    private $config;

    public function __construct()
    {
        $this->config = require __DIR__ . "/../config/config.php";
    }

    public function getAccessToken()
    {
        if (file_exists(TOKEN_FILE)) {
            $tokenData = json_decode(file_get_contents(TOKEN_FILE), true);
            if (time() < $tokenData["expires_at"]) {
                return $tokenData["access_token"];
            }
        }
        return $this->generateToken();
    }

    private function generateToken()
    {
        $data = [
            "grant_type"    => "client_credentials",
            "client_id"     => $this->config["admitad"]["client_id"],
            "client_secret" => $this->config["admitad"]["client_secret"],
            "scope"         => "advcampaigns websites"
        ];

        $ch = curl_init(ADMITAD_TOKEN_URL);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($data),
            CURLOPT_RETURNTRANSFER => true
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($response, true);

        if (!isset($result["access_token"])) {
            throw new Exception("Token generation failed");
        }

        $tokenData = [
            "access_token" => $result["access_token"],
            "expires_at" => time() + $result["expires_in"] - 60
        ];

        file_put_contents(TOKEN_FILE, json_encode($tokenData));
        return $tokenData["access_token"];
    }
}
