<?php

require_once __DIR__ . "/AdmitadAuth.php";
require_once __DIR__ . "/../config/constants.php";

class AdmitadClient
{
    private $auth;

    public function __construct()
    {
        $this->auth = new AdmitadAuth();
    }

    public function get($endpoint, $params = [])
    {
        $token = $this->auth->getAccessToken();

        $url = ADMITAD_API_BASE . $endpoint;
        if ($params) {
            $url .= "?" . http_build_query($params);
        }

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                "Authorization: Bearer $token"
            ]
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }
}
