<?php

require_once __DIR__ . "/../config/constants.php";

class Cache
{
    public static function get($key, $ttl)
    {
        $file = CACHE_DIR . md5($key) . ".json";
        if (file_exists($file) && (time() - filemtime($file)) < $ttl) {
            return json_decode(file_get_contents($file), true);
        }
        return null;
    }

    public static function put($key, $data)
    {
        file_put_contents(
            CACHE_DIR . md5($key) . ".json",
            json_encode($data)
        );
    }
}
